
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Director X and Director Y
values_director_x = [0.78, 0.82, 0.74, 0.89, 0.68, 0.85, 0.80, 0.77]  # Director X ratings
values_director_y = [0.88, 0.79, 0.83, 0.72, 0.87, 0.75, 0.90, 0.82]  # Director Y ratings

num_vars = len(values_director_x)
labels = ["Director X", "Director Y"]
ticks = [0.1, 0.3, 0.5, 0.7, 0.9]
tickslabel = ["10%", "30%", "50%", "70%", "90%"]

angle_labels = ["Storytelling", "Cinematography", "Pacing", "Soundtrack", "Acting", "Direction", "Editing", "Visual Effects"]
title = "Movie Ratings Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values_director_x += values_director_x[:1]
values_director_y += values_director_y[:1]
angles += angles[:1]

# Draw the radar chart
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))
ax.fill(angles, values_director_x, color="blue", alpha=0.1)
ax.plot(angles, values_director_x, color="blue", linewidth=2, linestyle='solid', label=labels[0])
ax.scatter(angles[:-1], values_director_x[:-1], color="blue", s=50, marker="o")
ax.fill(angles, values_director_y, color="green", alpha=0.1)
ax.plot(angles, values_director_y, color="green", linewidth=2, linestyle='dashed', label=labels[1])
ax.scatter(angles[:-1], values_director_y[:-1], color="green", s=50, marker="^")

# Add labels to the plot
ax.set_yticklabels([])
grid_angles = np.linspace(0, 2 * np.pi, 8, endpoint=False)
ax.set_xticks(grid_angles)
ax.set_xticklabels(angle_labels, fontsize=12, fontweight='bold')

# Add grid lines and labels for the concentric circles
ax.set_rgrids(
    ticks,
    labels=tickslabel,
    angle=30,
    color="grey",
    size=10,
)

# Create legend handles manually
legend_elements = [
    Line2D([0], [0], color="blue", linewidth=2, marker="o", markersize=8, linestyle='solid', label=labels[0]),
    Line2D([0], [0], color="green", linewidth=2, marker="^", markersize=8, linestyle='dashed', label=labels[1]),
]

# Add legend and title
ax.legend(handles=legend_elements, loc="upper right", bbox_to_anchor=(1.1, 1.1), frameon=False)
ax.set_title(title, size=16, color="darkred", fontweight='bold', pad=30)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_28.pdf", bbox_inches="tight")
