
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the data for each entertainment venue
labels = np.array(
    [
        "Ambiance",
        "Food Quality",
        "Service",
        "Pricing",
        "Location",
    ]
)
stats = np.array([[4, 5, 3, 4, 5], [3, 4, 5, 2, 4], [5, 3, 4, 5, 3]])
titles = ["Venue A", "Venue B", "Venue C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 6), nrows=1, ncols=3, subplot_kw=dict(polar=True))

# Define the number of variables
num_vars = len(labels)
# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]

colors = ["#2E8B57", "#1E90FF", "#FF8C00"]  # Green, Blue, Orange

# Draw one radar chart for each entertainment venue
for idx, (title, case_data) in enumerate(zip(titles, stats)):
    thisColor = colors[idx]
    ax[idx].fill(
        angles, case_data, color=thisColor, alpha=0.25
    )  # Fill with transparency
    ax[idx].plot(
        angles, case_data, color=thisColor, linewidth=2, linestyle="solid", marker="o"
    )
    ax[idx].set_yticks([1, 2, 3, 4, 5])
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels)
    ax[idx].set_title(title, size=14, color="black", position=(0.5, -0.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_31.pdf", bbox_inches="tight")
