
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the radar chart
labels = np.array(
    [
        "[1] Economic Policy",
        "[2] Social Policy",
        "[3] Environment",
        "[4] Healthcare",
        "[5] Education",
        "[6] Defense",
        "[7] Immigration",
        "[8] Law & Order",
        "[9] Technology",
        "[10] International Relations",
    ]
)
conservative_values = np.array([70, 60, 50, 55, 65, 80, 70, 85, 60, 75])
liberal_values = np.array([50, 75, 85, 80, 90, 60, 55, 70, 75, 65])
yticks = [20, 40, 60, 80, 100]
ytickslabel = ["20", "40", "60", "80", "100"]
ylim = [0, 120]
labels2 = ["Conservative", "Liberal"]
rgrids = [40, 60, 80, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure

fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
conservative_values = np.concatenate((conservative_values, [conservative_values[0]]))
liberal_values = np.concatenate((liberal_values, [liberal_values[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], [], color="black", size=8, ha="right")
for angle, label in zip(angles[:-1], labels):  # Remove the appended first element
    if (
        angle < np.pi / 2 or angle > 3 * np.pi / 2
    ):  # If the text is at the bottom or right side of the chart
        ax.text(
            angle,
            125,
            label,
            horizontalalignment="left",
            size=8,
            verticalalignment="bottom",
        )
    else:  # If the text is at the top or left side of the chart
        ax.text(
            angle,
            125,
            label,
            horizontalalignment="right",
            size=8,
            verticalalignment="bottom",
        )

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(
    yticks,
    ytickslabel,
    color="grey",
    size=8,
)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    conservative_values,
    linewidth=1,
    linestyle="dashed",
    label=labels2[0],
    color="brown",
    marker='o',
    markersize=5,
)
ax.fill(angles, conservative_values, "brown", alpha=0.1)

ax.plot(
    angles,
    liberal_values,
    linewidth=2,
    linestyle="solid",
    label=labels2[1],
    color="green",
    marker='s',
    markersize=5,
)
ax.fill(angles, liberal_values, "green", alpha=0.1)

# Add legend
plt.legend(loc="upper right", bbox_to_anchor=(0.1, 0.1))

# Adjust gridlines
ax.set_rgrids(
    rgrids,
    labels=rgrids,
    angle=0,
    color="black",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_34.pdf", bbox_inches="tight")
