
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the radar chart
labels = np.array(
    [
        "Economic Stability",
        "Military Strength",
        "Cultural Influence",
        "Scientific Advancements",
        "Social Hierarchies",
        "Technological Innovation",
        "Political Stability",
        "Educational Systems",
        "Public Health",
        "Infrastructure",
    ]
)
scenario1_values = np.array([80, 70, 90, 85, 60, 75, 65, 80, 55, 70])
scenario2_values = np.array([85, 80, 75, 90, 50, 85, 70, 75, 60, 80])
yticks = [10, 20, 30, 40, 50, 60, 70, 80, 90]
ytickslabel = ["10", "20", "30", "40", "50", "60", "70", "80", "90"]
ylim = [0, 100]
labels2 = ["Renaissance", "Industrial Revolution"]
rgrids = [30, 40, 50, 60, 70, 80, 90]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
scenario1_values = np.concatenate((scenario1_values, [scenario1_values[0]]))
scenario2_values = np.concatenate((scenario2_values, [scenario2_values[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], [], color="black", size=8, ha="right")
for angle, label in zip(angles[:-1], labels):  # Remove the appended first element
    if (
        angle < np.pi / 2 or angle > 3 * np.pi / 2
    ):  # If the text is at the bottom or right side of the chart
        ax.text(
            angle,
            110,
            label,
            horizontalalignment="left",
            size=8,
            verticalalignment="bottom",
        )
    else:  # If the text is at the top or left side of the chart
        ax.text(
            angle,
            110,
            label,
            horizontalalignment="right",
            size=8,
            verticalalignment="bottom",
        )

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(
    yticks,
    ytickslabel,
    color="grey",
    size=8,
)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    scenario1_values,
    linewidth=1.5,
    linestyle="--",
    label=labels2[0],
    color="green",
    marker='o',
)
ax.fill(angles, scenario1_values, "green", alpha=0.1)

ax.plot(
    angles,
    scenario2_values,
    linewidth=1.5,
    linestyle="-.",
    label=labels2[1],
    color="purple",
    marker='s',
)
ax.fill(angles, scenario2_values, "purple", alpha=0.1)

# Add legend
plt.legend(loc="upper right", bbox_to_anchor=(0.1, 0.1))

# Adjust gridlines
ax.set_rgrids(
    rgrids,
    labels=rgrids,
    angle=0,
    color="black",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_35.pdf", bbox_inches="tight")
