
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each line
values_yield = [0.85, 0.88, 0.83, 0.86, 0.90, 0.87]
values_disease_resistance = [0.75, 0.78, 0.80, 0.74, 0.77, 0.79]
values_water_efficiency = [0.65, 0.68, 0.70, 0.72, 0.69, 0.66]
values_nutrient_requirement = [0.55, 0.60, 0.58, 0.62, 0.57, 0.59]
xtickslabel = [
    "Crop_Variety_A",
    "Crop_Variety_B",
    "Crop_Variety_C",
    "Crop_Variety_D",
    "Crop_Variety_E",
    "Crop_Variety_F",
]
y_ticks = [0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
labels = [
    "Yield",
    "Disease Resistance",
    "Water Efficiency",
    "Nutrient Requirement",
]
ylim = [0.5, 1.0]

# Labels for y axis
y_labels_custom_1 = ["0.65"] * len(xtickslabel)
y_labels_custom_2 = ["0.75"] * len(xtickslabel)

title = "Agricultural Crop Varieties Performance Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and polar axis
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values_yield)
# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values_yield += values_yield[:1]
values_disease_resistance += values_disease_resistance[:1]
values_water_efficiency += values_water_efficiency[:1]
values_nutrient_requirement += values_nutrient_requirement[:1]

# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xtickslabel,
    color="black",
    size=10,
)


# Define the range of y-axis and y-labels
plt.yticks(y_ticks, [str(i) for i in y_ticks], color="black", size=10)
# add_custom_y_labels(ax, angles[:-1], y_labels_custom_1, 0.65)
# add_custom_y_labels(ax, angles[:-1], y_labels_custom_2, 0.75)

# Set y-axis limit
plt.ylim(ylim)

# Plot data and fill area for each line
colors = ["navy", "gold", "teal", "crimson"]

ax.plot(
    angles,
    values_yield,
    linewidth=2,
    linestyle="solid",
    label=labels[0],
    color=colors[0],
    marker="o",
)
ax.fill(angles, values_yield, colors[0], alpha=0.1)

ax.plot(
    angles,
    values_disease_resistance,
    linewidth=2,
    linestyle="dashed",
    label=labels[1],
    color=colors[1],
    marker="s",
)
ax.fill(angles, values_disease_resistance, colors[1], alpha=0.1)

ax.plot(
    angles,
    values_water_efficiency,
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    color=colors[2],
    marker="^",
)
ax.fill(angles, values_water_efficiency, colors[2], alpha=0.1)

ax.plot(
    angles,
    values_nutrient_requirement,
    linewidth=2,
    linestyle="dotted",
    label=labels[3],
    color=colors[3],
    marker="D",
)
ax.fill(angles, values_nutrient_requirement, colors[3], alpha=0.1)

# Add legend with a different style
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.25), ncol=2)

# Title
plt.title(title, size=15, color="black", position=(0.5, 1.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_37.pdf", bbox_inches="tight")
