
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each sustainability model
values_carbon = [0.60, 0.70, 0.65, 0.75, 0.80, 0.85]
values_energy = [0.55, 0.65, 0.60, 0.70, 0.75, 0.80]
values_waste = [0.50, 0.60, 0.55, 0.65, 0.70, 0.75]
values_water = [0.45, 0.55, 0.50, 0.60, 0.65, 0.70]
xtickslabel = ["Model_A", "Model_B", "Model_C", "Model_D", "Model_E", "Model_F"]
y_ticks = [0.40, 0.50, 0.60, 0.70, 0.80, 0.90]
labels = [
    "Carbon Footprint Reduction",
    "Renewable Energy Usage",
    "Waste Management Efficiency",
    "Water Conservation",
]
ylim = [0.4, 0.9]

title = "Sustainability Model Performance Radar Chart"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and polar axis
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values_carbon)
# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values_carbon += values_carbon[:1]
values_energy += values_energy[:1]
values_waste += values_waste[:1]
values_water += values_water[:1]

# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xtickslabel,
    color="black",
    size=8,
)


# Define the range of y-axis and y-labels

plt.yticks(y_ticks, [str(i) for i in y_ticks], color="black", size=7)

# Set y-axis limit
plt.ylim(ylim)

# Plot data and fill area for each line
ax.plot(
    angles,
    values_carbon,
    linewidth=2,
    linestyle="dashed",
    label=labels[0],
    color="#1f77b4",
    marker="o",
)
ax.fill(angles, values_carbon, "#1f77b4", alpha=0.1)

ax.plot(
    angles,
    values_energy,
    linewidth=2,
    linestyle="dotted",
    label=labels[1],
    color="#ff7f0e",
    marker="s",
)
ax.fill(angles, values_energy, "#ff7f0e", alpha=0.1)

ax.plot(
    angles,
    values_waste,
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    color="#2ca02c",
    marker="^",
)
ax.fill(angles, values_waste, "#2ca02c", alpha=0.1)

ax.plot(
    angles,
    values_water,
    linewidth=2,
    linestyle="solid",
    label=labels[3],
    color="#d62728",
    marker="*",
)
ax.fill(angles, values_water, "#d62728", alpha=0.1)

# Add legend with a different style
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=2)

# Add title
plt.title(title, size=14, color="#333333")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_38.pdf", bbox_inches="tight")
