
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each line
labels = np.array(
    [
        "Strength",
        "Endurance",
        "Flexibility",
        "Balance",
        "Speed",
        "Agility",
        "Coordination",
        "Reaction Time",
    ]
)
num_vars = len(labels)

values1 = np.array([6.5, 7.8, 6.2, 7.7, 8.9, 6.0, 7.1, 7.3])
values2 = np.array([7.7, 6.1, 7.5, 6.8, 7.2, 6.9, 8.6, 7.0])
values3 = np.array([5.2, 4.4, 5.1, 6.5, 4.9, 5.3, 6.0, 5.2])
labels2 = ["January Metrics", "February Metrics", "March Metrics"]
yticks = [2, 4, 6, 8, 10]
ytickslabel = ["2", "4", "6", "8", "10"]
ylim = [0, 10]

title = "Fitness Performance Comparison by Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Color Scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
values1 = np.concatenate((values1, [values1[0]]))
values2 = np.concatenate((values2, [values2[0]]))
values3 = np.concatenate((values3, [values3[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, fontsize=12, color="darkblue")

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="black", size=10)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle="solid",
    label=labels2[0],
    color=colors[0],
    marker="o",
)
ax.fill(angles, values1, colors[0], alpha=0.25)

ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle="dashed",
    label=labels2[1],
    color=colors[1],
    marker="s",
)
ax.fill(angles, values2, colors[1], alpha=0.25)

ax.plot(
    angles,
    values3,
    linewidth=2,
    linestyle="dotted",
    label=labels2[2],
    color=colors[2],
    marker="D",
)
ax.fill(angles, values3, colors[2], alpha=0.25)

# Add legend
plt.legend(loc="lower left", bbox_to_anchor=(-0.15, -0.1), fontsize=12)

# Title
plt.title(title, size=16, color="darkred", y=1.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_39.pdf", bbox_inches="tight")
