

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the data for each genre
labels = np.array(
    [
        "Logical Consistency",
        "Historical Significance",
        "Influence",
        "Complexity",
        "Relevance",
        "Originality",
        "Clarity",
        "Intersectionality",
        "Philosophical Depth",
    ]
)
num_vars = len(labels)

# New data for philosophy categories
values1 = np.array([4.7, 4.5, 4.9, 4.0, 3.8, 4.5, 4.2, 4.0, 4.8])
values2 = np.array([4.4, 3.8, 4.1, 4.5, 4.2, 4.0, 4.3, 4.8, 4.6])
values3 = np.array([4.1, 4.7, 3.9, 3.8, 4.4, 4.2, 4.0, 3.9, 4.3])
labels2 = ["Ethics", "Epistemology", "Metaphysics"]
yticks = [1, 2, 3, 4, 5]
ytickslabel = ["1", "2", "3", "4", "5"]
ylim = [0, 5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
values1 = np.concatenate((values1, [values1[0]]))
values2 = np.concatenate((values2, [values2[0]]))
values3 = np.concatenate((values3, [values3[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="black", size=7)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle="solid",
    label=labels2[0],
    color="#1f77b4",  # Blue
    marker="o",
)
ax.fill(angles, values1, "#1f77b4", alpha=0.1)

ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle="dashed",
    label=labels2[1],
    color="#ff7f0e",  # Orange
    marker="s",
)
ax.fill(angles, values2, "#ff7f0e", alpha=0.1)

ax.plot(
    angles,
    values3,
    linewidth=2,
    linestyle="dotted",
    label=labels2[2],
    color="#2ca02c",  # Green
    marker="D",
)
ax.fill(angles, values3, "#2ca02c", alpha=0.1)

# Add legend
plt.legend(loc="lower left", bbox_to_anchor=(-0.15, -0.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_41.pdf", bbox_inches="tight")

