

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for each individual
labels = np.array(
    [
        "Cardiovascular\nHealth",
        "Strength",
        "Flexibility",
        "Endurance",
        "Body\nComposition",
    ]
)
stats_individual_a = np.array([80, 70, 75, 85, 90])
stats_individual_b = np.array([75, 85, 70, 80, 65])
stats_individual_c = np.array([65, 60, 85, 70, 80])

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular, so we need to "complete the loop" and append the start to the end.
stats_individual_a = np.concatenate((stats_individual_a, [stats_individual_a[0]]))
stats_individual_b = np.concatenate((stats_individual_b, [stats_individual_b[0]]))
stats_individual_c = np.concatenate((stats_individual_c, [stats_individual_c[0]]))
angles += angles[:1]

# Extracted variables
label_individual_a = "Individual A"
label_individual_b = "Individual B"
label_individual_c = "Individual C"
xlim_values = None  # Not specified in the code
ylim_values = (0, 100)
xlabel_value = None  # Not specified in the code
ylabel_value = None  # Not specified in the code
xticks_values = angles[:-1]
yticks_values = [20, 40, 60, 80]
xtickslabel_values = labels
ytickslabel_values = []  # Empty list as specified in plt.yticks
title_value = "Physical Health Indicators Radar Chart"
axhline_value = None  # Not specified in the code
axvline_value = None  # Not specified in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels with increased padding
plt.xticks(xticks_values, xtickslabel_values)
ax.tick_params(pad=15)  # Increase the distance of the label from the axis

# Draw ylabels and set them to be dashed
ax.set_rlabel_position(0)
plt.yticks(yticks_values, ytickslabel_values, color="grey", size=8)
plt.ylim(ylim_values)

# Customizing the grid (set grid to be dashed)
ax.yaxis.grid(True, linestyle="--", color="grey", linewidth=0.5)

# Plot data
ax.plot(
    angles,
    stats_individual_a,
    color="orange",
    linewidth=2,
    linestyle="solid",
    marker='o',
    markersize=5,
    label=label_individual_a,
)
ax.fill(angles, stats_individual_a, color="orange", alpha=0.25)

ax.plot(
    angles,
    stats_individual_b,
    color="purple",
    linewidth=2,
    linestyle="dashed",
    marker='s',
    markersize=5,
    label=label_individual_b,
)
ax.fill(angles, stats_individual_b, color="purple", alpha=0.25)

ax.plot(
    angles,
    stats_individual_c,
    color="teal",
    linewidth=2,
    linestyle="dotted",
    marker='^',
    markersize=5,
    label=label_individual_c,
)
ax.fill(angles, stats_individual_c, color="teal", alpha=0.25)

# Add title
plt.title(title_value, size=15, color='black', y=1.1)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_42.pdf", bbox_inches="tight")

