
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for each community engagement group
labels = np.array(
    [
        "Volunteering",
        "Fundraising",
        "Neighborhood Watch",
        "Community Meetings",
        "Local Events",
    ]
)
stats_group1 = np.array([85, 75, 60, 90, 95])
stats_group2 = np.array([70, 80, 85, 60, 75])
stats_group3 = np.array([65, 70, 75, 80, 85])

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular, so we need to "complete the loop" and append the start to the end.
stats_group1 = np.concatenate((stats_group1, [stats_group1[0]]))
stats_group2 = np.concatenate((stats_group2, [stats_group2[0]]))
stats_group3 = np.concatenate((stats_group3, [stats_group3[0]]))
angles += angles[:1]

# Extracted variables
label_group1 = "Community Group 1"
label_group2 = "Community Group 2"
label_group3 = "Community Group 3"
xlim_values = None  # Not specified in the code
ylim_values = (0, 100)
xlabel_value = None  # Not specified in the code
ylabel_value = None  # Not specified in the code
xticks_values = angles[:-1]
yticks_values = [20, 40, 60, 80, 100]
xtickslabel_values = labels
ytickslabel_values = []  # Empty list as specified in plt.yticks
title_value = "Comparison of Community Engagement Among Groups"
axhline_value = None  # Not specified in the code
axvline_value = None  # Not specified in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels with increased padding
plt.xticks(xticks_values, xtickslabel_values)
ax.tick_params(pad=23)  # Increase the distance of the label from the axis

# Draw ylabels and set them to be dashed
ax.set_rlabel_position(0)
plt.yticks(yticks_values, ytickslabel_values, color="grey", size=7)
plt.ylim(ylim_values)

# Customizing the grid (set grid to be dashed)
ax.yaxis.grid(True, linestyle="--", color="grey", linewidth=0.5)

# Plot data
color_group1 = "#1f77b4"  # Blue color
ax.plot(
    angles,
    stats_group1,
    color=color_group1,
    linewidth=2,
    linestyle="solid",
    label=label_group1,
    marker='o'
)
ax.fill(angles, stats_group1, color=color_group1, alpha=0.25)

color_group2 = "#ff7f0e"  # Orange color
ax.plot(
    angles,
    stats_group2,
    color=color_group2,
    linewidth=2,
    linestyle="dashed",
    label=label_group2,
    marker='s'
)
ax.fill(angles, stats_group2, color=color_group2, alpha=0.25)

color_group3 = "#2ca02c"  # Green color
ax.plot(
    angles,
    stats_group3,
    color=color_group3,
    linewidth=2,
    linestyle="dotted",
    label=label_group3,
    marker='^'
)
ax.fill(angles, stats_group3, color=color_group3, alpha=0.25)

# Add title
plt.suptitle(title_value, fontsize=14, fontweight='bold')

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_44.pdf", bbox_inches="tight")
