
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define the data for the radar chart
categories = [
    "Efficiency",
    "Durability",
    "Cost",
    "Market Share",
    "Customer Satisfaction",
    "Innovation",
    "Speed",
    "Safety",
    "Environmental Impact",
]
N = len(categories)

# Values for each product strategy
Product_A = np.random.randint(60, 100, size=N).tolist()
Product_B = np.random.randint(50, 90, size=N).tolist()
Product_C = np.random.randint(40, 80, size=N).tolist()

# We need to repeat the first value to close the circular graph:
Product_A += Product_A[:1]
Product_B += Product_B[:1]
Product_C += Product_C[:1]

labels = ["Product A", "Product B", "Product C"]
title = "Product Performance Metrics\n(Comparison among Products)"
yticks = [20, 40, 60, 80, 100]
ylim = [0, 110]

# Calculate angle for each category
angles = [n / float(N) * 2 * pi for n in range(N)]
angles += angles[:1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], categories, color="black", size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [f"{ytick}%" for ytick in yticks], color="grey", size=10)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles, Product_A, linewidth=2, linestyle="solid", label=labels[0], color="#FF6361"
)
ax.plot(
    angles,
    Product_B,
    linewidth=2,
    linestyle="dashed",
    label=labels[1],
    color="#58508D",
)
ax.plot(
    angles,
    Product_C,
    linewidth=2,
    linestyle="dotted",
    label=labels[2],
    color="#FFA600",
)

# Add fill to the areas
ax.fill(angles, Product_A, color="#FF6361", alpha=0.3)
ax.fill(angles, Product_B, color="#58508D", alpha=0.3)
ax.fill(angles, Product_C, color="#FFA600", alpha=0.3)

# Add a title and a legend
plt.title(title, size=15, color="black", y=1.2)
plt.legend(loc="upper right", bbox_to_anchor=(1.3, 1.1))

ax.xaxis.set_tick_params(pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_50.pdf", bbox_inches="tight")
