
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data values
values_aristotle = [0.9, 0.5, 0.8, 0.6, 0.7]
values_plato = [0.7, 0.9, 0.6, 0.8, 0.5]
values_nietzsche = [0.6, 0.4, 0.7, 0.9, 0.8]
categories = ["Ethics", "Metaphysics", "Epistemology", "Logic", "Aesthetics"]
labels = ["Aristotle", "Plato", "Nietzsche"]

chart_title = "Philosophical Emphasis of Various Thinkers"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialise the radar plot
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(polar=True))

# Number of variables
N = len(categories)

# What will be the angle of each axis in the plot
angles = [n / float(N) * 2 * np.pi for n in range(N)]
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], categories)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks([0.2, 0.4, 0.6, 0.8], [], color="grey", size=7)
plt.ylim(0, 1)

# Plot data
ax.plot(
    angles,
    values_aristotle + values_aristotle[:1],
    color="#708090",  # Steel Grey
    linewidth=2,
    linestyle="solid",
    label=labels[0],
    marker="o",
)
ax.fill(angles, values_aristotle + values_aristotle[:1], color="#708090", alpha=0.1)

ax.plot(
    angles,
    values_plato + values_plato[:1],
    color="#228B22",  # Forest Green
    linewidth=2,
    linestyle="dashed",
    label=labels[1],
    marker="v",
)
ax.fill(angles, values_plato + values_plato[:1], color="#228B22", alpha=0.1)

ax.plot(
    angles,
    values_nietzsche + values_nietzsche[:1],
    color="#DC143C",  # Crimson
    linewidth=2,
    linestyle="dotted",
    label=labels[2],
    marker="s",
)
ax.fill(angles, values_nietzsche + values_nietzsche[:1], color="#DC143C", alpha=0.1)

# Add legend
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))

# Title and layout adjustments
plt.suptitle(chart_title, fontsize=14)
plt.tight_layout(rect=[0, 0, 0.85, 0.95])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.savefig("radar_55.pdf", bbox_inches="tight")
