
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data values for different transportation metrics
values_fuel_efficiency = [0.70, 0.75, 0.65, 0.72, 0.78]
values_emissions = [0.85, 0.80, 0.77, 0.79, 0.81]
values_congestion = [0.55, 0.60, 0.53, 0.58, 0.56]
categories = ["Fuel Efficiency", "Emissions", "Congestion", "Public Transport", "Infrastructure"]
labels = ["Region A", "Region B", "Region C"]

# Text labels
title = "Transportation Metrics Across Regions"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialise the radar plot
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(polar=True))

# Number of variables
N = len(categories)

# What will be the angle of each axis in the plot
angles = [n / float(N) * 2 * np.pi for n in range(N)]
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], categories)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks([0.2, 0.4, 0.6, 0.8], [], color="grey", size=7)
plt.ylim(0, 1)

# Plot data
ax.plot(
    angles,
    values_fuel_efficiency + values_fuel_efficiency[:1],
    color="seagreen",
    linewidth=2,
    linestyle="dashdot",
    label=labels[0],
    marker="o",
)
ax.fill(
    angles, values_fuel_efficiency + values_fuel_efficiency[:1], color="seagreen", alpha=0.25
)

ax.plot(
    angles,
    values_emissions + values_emissions[:1],
    color="steelblue",
    linewidth=2,
    linestyle="dashdot",
    label=labels[1],
    marker="s",
)
ax.fill(
    angles, values_emissions + values_emissions[:1], color="steelblue", alpha=0.25
)

ax.plot(
    angles,
    values_congestion + values_congestion[:1],
    color="mediumvioletred",
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    marker="^",
)
ax.fill(
    angles,
    values_congestion + values_congestion[:1],
    color="mediumvioletred",
    alpha=0.25,
)

# Add legend
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))

# Add title
plt.title(title, size=16, color="darkslategray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_56.pdf", bbox_inches="tight")
