

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New data for the radar chart in the geography domain
labels = np.array(
    [
        "Elevation",
        "Rainfall",
        "Temperature",
        "Humidity",
        "Wind Speed",
        "Sunlight",
    ]
)
stats_location_a = np.array(
    [0.8, 0.6, 0.7, 0.9, 0.5, 0.8]
)
stats_location_b = np.array([0.6, 0.8, 0.9, 0.7, 0.8, 0.6])
xticks = [0.2, 0.4, 0.6, 0.8]
xtickslabel = ["0.2", "0.4", "0.6", "0.8"]
label_a = "Location A"
label_b = "Location B"
chart_title = "Geographic Location Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
stats_location_a = np.concatenate((stats_location_a, [stats_location_a[0]]))
stats_location_b = np.concatenate((stats_location_b, [stats_location_b[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=15)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rscale("linear")
plt.yticks(xticks, xtickslabel, color="grey", size=7)
plt.ylim(0, 1)

# Plot data with new styles
ax.plot(
    angles,
    stats_location_a,
    linewidth=2,
    linestyle="dashed",
    label=label_a,
    marker="o",
    color="#4CAF50",  # A shade of green
)
ax.plot(
    angles,
    stats_location_b,
    linewidth=2,
    linestyle="solid",
    label=label_b,
    marker="s",
    color="#2196F3",  # A shade of blue
)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=2)

# Add a title
plt.title(chart_title, size=14, color="#444444", y=1.1)

# Add grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_59.pdf", bbox_inches="tight")

