
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New labels and data
labels = np.array(
    [
        "Internet Penetration",
        "Mobile Usage",
        "AI Adoption",
        "Blockchain Adoption",
        "Cloud Usage",
        "Cybersecurity Investment",
        "IoT Adoption",
        "5G Coverage",
    ]
)

North_America = np.array([0.9, 0.95, 0.85, 0.8, 0.9, 0.85, 0.8, 0.75])
South_America = np.array([0.6, 0.7, 0.5, 0.4, 0.55, 0.5, 0.45, 0.4])
Europe = np.array([0.8, 0.85, 0.75, 0.7, 0.8, 0.75, 0.7, 0.65])
Asia = np.array([0.7, 0.8, 0.7, 0.6, 0.75, 0.6, 0.65, 0.6])

yticks = [0.2, 0.4, 0.6, 0.8, 1.0]
labels2 = ["North America", "South America", "Europe", "Asia"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular, so we need to complete the loop
North_America = np.concatenate((North_America, [North_America[0]]))
South_America = np.concatenate((South_America, [South_America[0]]))
Europe = np.concatenate((Europe, [Europe[0]]))
Asia = np.concatenate((Asia, [Asia[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=12)
ax.tick_params(pad=10)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [str(ytick) for ytick in yticks], color="grey", size=10)
plt.ylim(0, 1)

# Plot data
ax.plot(
    angles,
    North_America,
    color="#2E4057",
    linewidth=2,
    linestyle="solid",
    label=labels2[0],
    marker="o",
)
ax.plot(
    angles,
    South_America,
    color="#D9534F",
    linewidth=2,
    linestyle="dashed",
    label=labels2[1],
    marker="v",
)
ax.plot(
    angles,
    Europe,
    color="#5BC0DE",
    linewidth=2,
    linestyle="dotted",
    label=labels2[2],
    marker="s",
)
ax.plot(
    angles,
    Asia,
    color="#5CB85C",
    linewidth=2,
    linestyle="dashdot",
    label=labels2[3],
    marker="^",
)

# Add legend
plt.legend(loc="upper left", bbox_to_anchor=(1, 1.2))
ax.xaxis.set_tick_params(pad=40)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_60.pdf", bbox_inches="tight")
