
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for each sports performance metric
player_endurance = [78, 85, 90, 70, 75]  # Player Endurance Index
scoring_efficiency = [65, 80, 88, 60, 70]  # Scoring Efficiency
defensive_capability = [50, 55, 60, 45, 50]  # Defensive Capability
xtickslabel = ["North\nAmerica", "Europe", "Asia", "Africa", "South\nAmerica"]
yticks = [20, 40, 60, 80, 100]
ytickslabel = ["20", "40", "60", "80", "100"]
ylim = [0, 100]
xlabel = "Regions"
ylabel = "Index/Percentage"
labels = ["Player Endurance Index", "Scoring Efficiency", "Defensive Capability"]
chart_title = "Sports Performance Metrics by Region"

# Number of variables
num_vars = len(player_endurance)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
player_endurance += player_endurance[:1]
scoring_efficiency += scoring_efficiency[:1]
defensive_capability += defensive_capability[:1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], xtickslabel, size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="grey", size=7)
plt.ylim(ylim)

# Define colors
color_endurance = "mediumseagreen"
color_scoring = "deepskyblue"
color_defensive = "darkolivegreen"

# Plot each sports performance metric
ax.plot(
    angles,
    player_endurance,
    linewidth=2,
    linestyle="solid",
    label=labels[0],
    color=color_endurance,
    marker="o",
)
ax.fill(angles, player_endurance, color_endurance, alpha=0.1)

ax.plot(
    angles,
    scoring_efficiency,
    linewidth=2,
    linestyle="dashed",
    label=labels[1],
    color=color_scoring,
    marker="s",
)
ax.fill(angles, scoring_efficiency, color_scoring, alpha=0.1)

ax.plot(
    angles,
    defensive_capability,
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    color=color_defensive,
    marker="^",
)
ax.fill(angles, defensive_capability, color_defensive, alpha=0.1)

# Add a legend to the upper right
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3)

# Add chart title
plt.title(chart_title, size=15, color="darkslategrey")
ax.xaxis.set_tick_params(pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)

# Adjust layout
plt.tight_layout()

plt.savefig("radar_66.pdf", bbox_inches="tight")
