
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the new data for each energy management strategy
labels = np.array(
    ["Efficiency", "Renewable Use", "Operational Cost", "Carbon Footprint", "Reliability"]
)
stats = np.array(
    [
        [4, 5, 3, 2, 4],  # Green Energy Initiative
        [3, 2, 4, 5, 3],  # Traditional Energy Plan
        [4, 3, 4, 3, 5],  # Hybrid Energy Model
    ]
)
titles = ["Green Energy Initiative", "Traditional Energy Plan", "Hybrid Energy Model"]
rticks = [1, 2, 3, 4, 5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(12, 8), nrows=1, ncols=3, subplot_kw=dict(polar=True))
# Define the number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]
# Define colors
colors = ["#FF6F61", "#6B5B95", "#88B04B"]

# Draw one radar chart for each energy management strategy
for idx, (title, case_data) in enumerate(zip(titles, stats)):
    ax[idx].fill(angles, case_data, color=colors[idx], alpha=0.25)
    ax[idx].plot(angles, case_data, color=colors[idx], linewidth=2, linestyle='--', marker='o')
    ax[idx].set_rticks(rticks)
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels)
    ax[idx].set_title(title, color=colors[idx])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

plt.savefig("radar_71.pdf", bbox_inches="tight")
