
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
    "San Antonio",
    "San Diego",
    "Dallas",
]
values = {
    "Population (Millions)": np.random.uniform(1.0, 10.0, len(cities)),
    "Population Growth Rate (%)": np.random.uniform(0.1, 3.0, len(cities)),
    "Median Age": np.random.uniform(30, 40, len(cities)),
    "Employment Rate (%)": np.random.uniform(60, 95, len(cities)),
    "Birth Rate (per 1,000)": np.random.uniform(10, 20, len(cities)),
    "Crime Rate (per 1,000)": np.random.uniform(20, 50, len(cities)),
}

# Plot labels
xlabel = "Value"
title = "City Population Characteristics"
suptitle = "Comparison of Various US Cities"
legendlabels = list(values.keys())

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#2E8B57", "#8B4513", "#556B2F", "#FFD700", "#8B0000", "#4682B4"]
markers = ["o", "s", "D", "^", "v", "*"]

# Create subplots
fig, axes = plt.subplots(1, 6, figsize=(15, 5), sharey=True)

# Plot each category
for ax, (category, color, marker) in zip(axes, zip(values.keys(), colors, markers)):
    ax.scatter(values[category], cities, color=color, marker=marker)
    ax.set_title(category)
    ax.set_xlim(min(values[category]) - 1, max(values[category]) + 1)
    ax.axvline(x=np.median(values[category]), color="black", linestyle="--", linewidth=1)

# Set common labels
fig.text(0.5, 0.04, xlabel, ha="center", va="center")
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout(rect=[0.03, 0.05, 1, 0.95])
plt.savefig("scatter_26.pdf", bbox_inches="tight")
