
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Scientific research methods
methods = [
    "Experimental Method",
    "Observational Study",
    "Simulation",
    "Case Study",
    "Survey",
    "Longitudinal Study",
    "Cross-Sectional Study",
    "Field Experiment",
    "Meta-Analysis",
]

# Values for each category
values = {
    "Accuracy": [85.2, 78.4, 92.5, 87.3, 81.9, 84.7, 79.0, 90.3, 88.1],
    "Precision": [80.1, 70.5, 89.3, 83.6, 76.8, 80.0, 72.9, 88.4, 85.2],
    "Recall": [78.5, 75.0, 91.0, 86.1, 79.2, 83.1, 74.3, 89.9, 86.5],
    "F1 Score": [79.3, 72.6, 90.1, 84.8, 77.9, 81.5, 73.6, 89.1, 85.8],
    "AUC-ROC": [82.4, 76.1, 88.7, 85.0, 79.5, 83.9, 75.8, 87.0, 86.0],
    "Sensitivity": [75.6, 72.0, 90.2, 83.5, 78.1, 81.7, 70.0, 88.2, 84.5],
}

# Text labels
xlabel = "Science Metrics"
title = "Scientific Methods Performance across Various Metrics"
supertitle = "Performance Metrics in Scientific Research Methods"
legendlabels = list(values.keys())

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
markers = ["o", "s", "D", "^", "v", "<"]

fig, axes = plt.subplots(1, 6, figsize=(15, 6), sharey=True)

for ax, (category, color, marker) in zip(axes, zip(values.keys(), colors, markers)):
    ax.scatter(values[category], methods, color=color, marker=marker, edgecolor="black")
    ax.set_title(category)
    ax.set_xlim(70, 95)
    ax.axvline(x=80, color="gray", linestyle="--", linewidth=1)

# Set common labels
fig.text(0.5, 0.04, xlabel, ha="center", va="center")
fig.suptitle(supertitle, fontsize=14)

# Add legend
fig.legend(legendlabels, loc="upper center", bbox_to_anchor=(0.5, 1.1), ncol=3)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0.03, 0.07, 1, 0.95])
plt.savefig("scatter_27.pdf", bbox_inches="tight")
