
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
models = [
    "gpt-law-1",
    "lex-davinci-003",
    "lex-davinci-002",
    "legal-claude-1",
    "legal-claude-2",
    "legal-bison@002",
    "hf_juris-40b",
    "law-llama-2-70",
    "law-llama-2-70-chat",
]
values = {
    "Public Speaking": [2.8, 3.6, 2.7, 3.5, 2.9, 3.4, 3.8, 3.3, 3.5],
    "Interpersonal Communication": [3.0, 3.8, 2.9, 2.7, 3.1, 3.6, 3.2, 3.5, 3.4],
    "Written Communication": [2.5, 2.7, 2.6, 2.8, 2.4, 2.9, 2.3, 3.1, 3.2],
    "Listening Skills": [2.9, 3.5, 2.8, 2.4, 2.0, 3.3, 3.6, 3.2, 3.1],
    "Team Collaboration": [3.2, 3.4, 3.3, 2.5, 2.1, 2.6, 2.7, 2.9, 3.0],
    "Conflict Resolution": [2.0, 2.9, 2.1, 2.8, 3.2, 3.7, 3.3, 3.0, 2.5],
}

# Axis labels and other text
xlabel = "Performance Value"
title = "AI Models Communication Skills Performance Comparison"
labels = list(values.keys())

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#4E79A7", "#F28E2B", "#E15759", "#76B7B2", "#59A14F", "#EDC948"]

# Create subplots
fig, axes = plt.subplots(1, 6, figsize=(15, 6), sharey=True)

# Plot each category
for ax, (category, color) in zip(axes, zip(values.keys(), colors)):
    ax.scatter(values[category], models, color=color, edgecolor='black', s=100, alpha=0.75)
    ax.set_title(category, fontsize=10)
    ax.set_xlim(2, 4)
    ax.axvline(x=3, color="grey", linestyle="--", linewidth=1)

# Set common labels and title
fig.text(0.5, 0.04, xlabel, ha='center', va='center', fontsize=12)
fig.suptitle(title, fontsize=14)

# Improve layout
plt.tight_layout(rect=[0.03, 0.06, 1, 0.95])

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("scatter_28.pdf", bbox_inches="tight")
