
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
x_north_america = [2000, 2010, 2020]
y_north_america = [20, 25, 30]
sizes_north_america = [300, 350, 400]

x_europe = [2000, 2010, 2020]
y_europe = [15, 18, 22]
sizes_europe = [250, 300, 350]

x_asia = [2000, 2010, 2020]
y_asia = [30, 35, 50]
sizes_asia = [400, 450, 500]

legend_labels = ["North America", "Europe", "Asia"]
title = "Growth of Student Enrollment in Different Regions"
xlabel = "Year (AD)"
ylabel = "Enrollment (Millions)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))  # Make the plot wider to fit the data better

# Scatter points
north_america_scatter = ax.scatter(
    x_north_america, y_north_america, s=sizes_north_america, alpha=0.8, color="#8B4513", marker="o"
)
europe_scatter = ax.scatter(
    x_europe, y_europe, s=sizes_europe, alpha=0.8, color="#CD5C5C", marker="s"
)
asia_scatter = ax.scatter(
    x_asia, y_asia, s=sizes_asia, alpha=0.8, color="#4682B4", marker="^"
)

# Connect points with lines
ax.plot(x_north_america, y_north_america, linestyle="--", color="#8B4513", alpha=0.8, linewidth=2)
ax.plot(x_europe, y_europe, linestyle="-.", color="#CD5C5C", alpha=0.8, linewidth=2)
ax.plot(x_asia, y_asia, linestyle=":", color="#4682B4", alpha=0.8, linewidth=2)

# Legend
legend = ax.legend(
    [north_america_scatter, europe_scatter, asia_scatter],
    legend_labels,
    title=title,
    loc="upper left",
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [50]  # 设置图例标记的大小

legend.get_frame().set_alpha(1)  # Make legend background opaque

# Axes labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_29.pdf", bbox_inches="tight")
