

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# New historical dataset clusters
clusters = {
    "Period_Antiquity": np.random.multivariate_normal([0, 5], [[0.5, 0.2], [0.2, 2]], 50),
    "Period_Middle_Ages": np.random.multivariate_normal([5, 15], [[0.5, 0.2], [0.2, 2]], 50),
    "Period_Renaissance": np.random.multivariate_normal([10, 30], [[0.5, 0.2], [0.2, 4]], 50),
    "Period_Early_Modern": np.random.multivariate_normal([15, 50], [[0.5, 0.2], [0.2, 5]], 50),
    "Period_Modern": np.random.multivariate_normal([20, 120], [[0.5, 0.2], [0.2, 10]], 50),
}

# Variables for plot configuration
xlim = (-5, 25)  # Example: centuries
ylim = (-10, 150)  # Example: number of technological advancements
xlabel = "Century"
ylabel = "Technological Advancements"
xticks = None
yticks = None
xtickslabel = None
ytickslabel = None
title = "Historical Periods and Technological Advancements"
axhline = None
axvline = None
legendlabels = {
    "Period_Antiquity": "Antiquity (0-5th Century)",
    "Period_Middle_Ages": "Middle Ages (6th-15th Century)",
    "Period_Renaissance": "Renaissance (16th-17th Century)",
    "Period_Early_Modern": "Early Modern (18th-19th Century)",
    "Period_Modern": "Modern (20th Century and beyond)",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(8, 6))

# New colors for each cluster
colors = {
    "Period_Antiquity": "#FF5733",
    "Period_Middle_Ages": "#33FF57",
    "Period_Renaissance": "#3357FF",
    "Period_Early_Modern": "#F39C12",
    "Period_Modern": "#8E44AD",
}

# New markers for each cluster
markers = {
    "Period_Antiquity": "o",
    "Period_Middle_Ages": "s",
    "Period_Renaissance": "D",
    "Period_Early_Modern": "v",
    "Period_Modern": "^",
}

for cluster, data in clusters.items():
    plt.scatter(data[:, 0], data[:, 1], c=colors[cluster], marker=markers[cluster], label=legendlabels[cluster], alpha=0.7)

# Set plot limits
if xlim:
    plt.xlim(xlim)
if ylim:
    plt.ylim(ylim)

# Set axis labels and title
if xlabel:
    plt.xlabel(xlabel)
if ylabel:
    plt.ylabel(ylabel)
if title:
    plt.title(title)

# Add legend
plt.legend()

# Remove grid for a cleaner look
plt.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_36.pdf", bbox_inches="tight")
