
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for entertainment sources, their number of shows, and average viewer ratings.
entertainment_sources = ["SourceA", "SourceB", "SourceC", "SourceD", "SourceE", "SourceF"]
shows = [10, 40, 100, 60, 200, 300]  # Number of shows produced.
viewer_ratings = [8.2, 7.5, 8.7, 8.0, 9.1, 7.8]  # Average viewer ratings.

xlabel = "Number of shows produced"  # X-axis label for number of shows.
ylabel = "Average viewer rating"  # Y-axis label for ratings.
title = "Shows vs. Viewer Ratings of Entertainment Sources"  # Title of the plot.
legendtitle = "Entertainment Sources"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and a subplot with a specific size.
fig, ax = plt.subplots(figsize=(8, 5))

# New color palette
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

# Scatter plot each entertainment source's data point and add text annotation.
for i in range(len(entertainment_sources)):
    ax.scatter(
        shows[i],
        viewer_ratings[i],
        color=colors[i],
        s=100,
        label=entertainment_sources[i],
        edgecolor="black",
    )  # Plot data points with specific color and edge color.
    # Align text annotations based on position for better readability.
    ax.text(
        shows[i] + 5,
        viewer_ratings[i],
        entertainment_sources[i],
        fontsize=10,
        ha="left",
        va="center",
        weight="bold",
    )

# Add a horizontal and a vertical dashed reference line.
ax.axhline(
    y=np.mean(viewer_ratings), color="gray", linestyle="--", linewidth=1
)  # Horizontal line at mean rating
ax.axvline(
    x=np.mean(shows), color="gray", linestyle="--", linewidth=1
)  # Vertical line at mean number of shows

# Set the scales of the axes to logarithmic.
ax.set_xscale("log")
ax.set_yscale("linear")

# Set the labels for the axes.
ax.set_xlabel(xlabel)  # X-axis label for number of shows.
ax.set_ylabel(ylabel)  # Y-axis label for ratings.

# Set the title of the plot.
ax.set_title(title)  # Title of the plot.

# Adjust the tick labels.
ax.set_xticks([10, 20, 50, 100, 200, 500])
ax.get_xaxis().set_major_formatter(plt.ScalarFormatter())
ax.set_yticks([7.0, 7.5, 8.0, 8.5, 9.0, 9.5])
ax.get_yaxis().set_major_formatter(plt.ScalarFormatter())

# Add a legend
ax.legend(title=legendtitle)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to ensure all elements fit within the figure area.
plt.tight_layout()
plt.savefig("scatter_44.pdf", bbox_inches="tight")
