
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for various companies, their Annual Revenue, and Turnover rates.
companies = ["Apple", "Microsoft", "Amazon", "Google", "Facebook", "Tesla"]
revenue = [260, 143, 252, 182, 86, 31]  # Annual Revenue in billions
turnover_rate = [10, 8, 15, 9, 12, 21]  # Turnover Rate (%)
xlabel = "Annual Revenue (in billions)"  # X-axis label for Revenue.
ylabel = "Employee Turnover Rate (%)"  # Y-axis label for Turnover Rate.
title = "Annual Revenue vs. Employee Turnover Rate across Companies"  # Title of the plot.
xlim = [0, 300]
ylim = [0, 30]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and a subplot with a specific size.
fig, ax = plt.subplots(figsize=(8, 5))

colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

# Scatter plot each company's data point and add text annotation.
for i in range(len(companies)):
    ax.scatter(
        revenue[i], turnover_rate[i], color=colors[i], s=100, label=companies[i]
    )  # Plot data points with specific color and size.
    # Align text annotations based on position for better readability.
    ax.text(
        revenue[i] + 1, turnover_rate[i] + 0.5, companies[i], fontsize=10, ha="left", va="bottom"
    )

# Add a horizontal and a vertical dashed reference line.
ax.axhline(
    y=10.0, color="gray", linestyle="--", linewidth=1
)  # Horizontal line at Turnover Rate=10%
ax.axvline(
    x=100.0, color="gray", linestyle="--", linewidth=1
)  # Vertical line at Revenue=100 billion

# Use standard scales for the axes.
ax.set_xscale("linear")
ax.set_yscale("linear")
ax.set_xlim(xlim)

# Set the labels for the axes.
ax.set_xlabel(xlabel)  # X-axis label for Revenue.
ax.set_ylabel(ylabel)  # Y-axis label for Turnover Rate.
ax.set_ylim(ylim)

# Set the title of the plot.
ax.set_title(title)  # Title of the plot.

# Adding grid for better readability.
ax.grid(True, which="both", linestyle='--', linewidth=0.5)

# Add Legend to explain the data points.
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to ensure all elements fit within the figure area.
plt.tight_layout()
plt.savefig("scatter_46.pdf", bbox_inches="tight")
