
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulate quarterly sales (in thousands of units) and profit margins (%) for different business segments
n_points = 200
small_business_sales = np.random.normal(50, 10, n_points)
small_business_profit = np.random.normal(5, 2, n_points)
medium_business_sales = np.random.normal(100, 20, n_points)
medium_business_profit = np.random.normal(10, 3, n_points)
large_business_sales = np.random.normal(200, 30, n_points)
large_business_profit = np.random.normal(15, 4, n_points)
enterprise_sales = np.random.normal(500, 50, n_points)
enterprise_profit = np.random.normal(20, 5, n_points)

xlabel = "Quarterly Sales (in thousands of units)"
ylabel = "Profit Margin (%)"
title = "Quarterly Sales vs Profit Margin across Business Segments"
legendtitle = "Business Segments"
scatter_labels = ["Small Business", "Medium Business", "Large Business", "Enterprise"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(10, 10))
plt.scatter(
    small_business_sales,
    small_business_profit,
    color="#1f77b4",
    alpha=0.6,
    label=scatter_labels[0],
    marker="o",
)
plt.scatter(
    medium_business_sales,
    medium_business_profit,
    color="#ff7f0e",
    alpha=0.6,
    label=scatter_labels[1],
    marker="s",
)
plt.scatter(
    large_business_sales,
    large_business_profit,
    color="#2ca02c",
    alpha=0.6,
    label=scatter_labels[2],
    marker="^",
)
plt.scatter(
    enterprise_sales,
    enterprise_profit,
    color="#9467bd",
    alpha=0.6,
    label=scatter_labels[3],
    marker="d",
)

plt.tick_params(axis="both", length=0)

# Add labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14, pad=20)
plt.legend(
    title=legendtitle,
    ncol=2,
    bbox_to_anchor=(0.5, 1.15),
    loc="upper center",
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_48.pdf", bbox_inches="tight")

