
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for Population Density vs Green Space plot
population_density_x = np.random.uniform(1000, 10000, 5).tolist()
green_space_y = np.random.uniform(5, 40, 5).tolist()
city_labels = ["MetroCity", "GreenVille", "EcoTown", "PolluCity", "CleanTown"]

# Data for Air Quality Index vs Population Density plot
air_quality_x = np.random.uniform(1000, 10000, 5).tolist()
population_density_y = np.random.uniform(20, 150, 5).tolist()
air_quality_labels = ["MetroCity", "GreenVille", "EcoTown", "PolluCity", "CleanTown"]

# Extracted variables for plot configuration
population_density_title = "Population Density vs Green Space"
population_density_xlabel = "Population Density (people/km²)"
population_density_ylabel = "Green Space Percentage (%)"
population_density_xlim = (0, 12000)
population_density_xticks = list(range(0, 13000, 2000))
population_density_ylim = (0, 50)
population_density_yticks = list(range(0, 55, 5))

air_quality_title = "Air Quality Index vs Population Density"
air_quality_xlabel = "Population Density (people/km²)"
air_quality_ylabel = "Air Quality Index"
air_quality_xlim = (0, 12000)
air_quality_xticks = list(range(0, 13000, 2000))
air_quality_ylim = (10, 160)
air_quality_yticks = list(range(10, 170, 20))

labels = []

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 10))

population_density_colors = ["#003f5c", "#2f4b7c", "#665191", "#a05195", "#d45087"]
air_quality_colors = ["#003f5c", "#2f4b7c", "#665191", "#a05195", "#d45087"]
population_density_markers = ["o", "s", "D", "^", "P"]
air_quality_markers = ["o", "s", "D", "^", "P"]

# Population Density vs Green Space plot
for x, y, color, label, marker in zip(
    population_density_x, green_space_y, population_density_colors, city_labels, population_density_markers
):
    if label == "MetroCity":
        ax1.scatter(
            x,
            y,
            label=label,
            facecolors="none",
            edgecolors=color,
            s=200,
            linewidths=4,
            marker=marker,
        )
    else:
        ax1.scatter(
            x, y, label=label, color=color, s=200, marker=marker
        )  # Increase marker size
ax1.set_title(population_density_title)
ax1.set_xlabel(population_density_xlabel)
ax1.set_ylabel(population_density_ylabel)
ax1.set_xlim(population_density_xlim)  # Adjust x-axis range
ax1.set_xticks(population_density_xticks)
ax1.set_ylim(population_density_ylim)  # Adjust y-axis range
ax1.set_yticks(population_density_yticks)
ax1.grid(True, linestyle="--", linewidth=0.5, color="gray")  # Add grid

# Air Quality Index vs Population Density plot
for x, y, color, label, marker in zip(
    air_quality_x,
    population_density_y,
    air_quality_colors,
    air_quality_labels,
    air_quality_markers,
):
    if label == "MetroCity":
        ax2.scatter(
            x,
            y,
            label=label,
            facecolors="none",
            edgecolors=color,
            s=200,
            linewidths=4,
            marker=marker,
        )
    else:
        ax2.scatter(
            x, y, label=label, color=color, s=200, marker=marker
        )  # Increase marker size
ax2.set_title(air_quality_title)
ax2.set_xlabel(air_quality_xlabel)
ax2.set_ylabel(air_quality_ylabel)
ax2.set_xlim(air_quality_xlim)  # Adjust x-axis range
ax2.set_xticks(air_quality_xticks)
ax2.set_ylim(air_quality_ylim)  # Adjust y-axis range
ax2.set_yticks(air_quality_yticks)
ax2.grid(True, linestyle="--", linewidth=0.5, color="gray")  # Add grid

legend_elements = [
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="MetroCity",
        markersize=10,
        markerfacecolor="none",
        markeredgewidth=4,
        markeredgecolor="#003f5c",
    ),
    Line2D(
        [0],
        [0],
        marker="s",
        color="w",
        label="GreenVille",
        markersize=10,
        markerfacecolor="#2f4b7c",
    ),
    Line2D(
        [0],
        [0],
        marker="D",
        color="w",
        label="EcoTown",
        markersize=10,
        markerfacecolor="#665191",
    ),
    Line2D(
        [0],
        [0],
        marker="^",
        color="w",
        label="PolluCity",
        markersize=10,
        markerfacecolor="#a05195",
    ),
    Line2D(
        [0],
        [0],
        marker="P",
        color="w",
        label="CleanTown",
        markersize=10,
        markerfacecolor="#d45087",
    ),
]

# Create the legend using the custom handles
fig.legend(
    handles=legend_elements,
    loc="lower center",
    ncol=5,
    borderaxespad=0.05,
    frameon=False,
)

# Adjust the layout to make room for the legend
plt.subplots_adjust(bottom=0.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_51.pdf", bbox_inches="tight")
