
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
# Random seed for reproducibility
import numpy as np

np.random.seed(42)

# Data for Philosophical Impact plot
impact_x = [0.9, 0.75, 0.85, 0.7, 0.95]
impact_y = np.random.uniform(60, 90, 5)
impact_labels = ["Philosopher A", "Philosopher B", "Philosopher C", "Philosopher D", "Philosopher E"]

# Data for School Popularity plot
popularity_x = [0.85, 0.65, 0.8, 0.87, 0.9]
popularity_y = np.random.uniform(30, 60, 5)
popularity_labels = [
    "School A",
    "School B",
    "School C",
    "School D",
    "School E",
]

# Extracted variables for plot configuration
impact_title = "Philosophical Impact"
impact_xlabel = "Impact Score"
impact_ylabel = "Influence (%)"
impact_xlim = (0.6, 1.0)
impact_xticks = [0.6, 0.7, 0.8, 0.9, 1.0]
impact_ylim = (55, 95)
impact_yticks = [60, 70, 80, 90]

popularity_title = "School Popularity"
popularity_xlabel = "Popularity Score"
popularity_ylabel = "Followership (%)"
popularity_xlim = (0.5, 1.0)
popularity_xticks = [0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
popularity_ylim = (25, 65)
popularity_yticks = [30, 40, 50, 60]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 10))

impact_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
popularity_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Philosophical Impact plot
for x, y, color, label in zip(
    impact_x, impact_y, impact_colors, impact_labels
):
    if label == "Philosopher A":
        ax1.scatter(
            x, y, label=label, facecolors="none", edgecolors=color, s=200, linewidths=4
        )
    else:
        ax1.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax1.set_title(impact_title)
ax1.set_xlabel(impact_xlabel)
ax1.set_ylabel(impact_ylabel)
ax1.set_xlim(impact_xlim)  # Adjust x-axis range
ax1.set_xticks(impact_xticks)
ax1.set_ylim(impact_ylim)  # Adjust y-axis range
ax1.set_yticks(impact_yticks)
ax1.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

# School Popularity plot
for x, y, color, label in zip(popularity_x, popularity_y, popularity_colors, popularity_labels):
    if label == "School A":
        ax2.scatter(
            x, y, label=label, facecolors="none", edgecolors=color, s=200, linewidths=4
        )
    else:
        ax2.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax2.set_title(popularity_title)
ax2.set_xlabel(popularity_xlabel)
ax2.set_ylabel(popularity_ylabel)
ax2.set_xlim(popularity_xlim)  # Adjust x-axis range
ax2.set_xticks(popularity_xticks)
ax2.set_ylim(popularity_ylim)  # Adjust y-axis range
ax2.set_yticks(popularity_yticks)
ax2.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

legend_elements = [
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Philosopher A / School A",
        markersize=10,
        markerfacecolor="none",
        markeredgewidth=4,
        markeredgecolor="#1f77b4",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Philosopher B / School B",
        markersize=10,
        markerfacecolor="#ff7f0e",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Philosopher C / School C",
        markersize=10,
        markerfacecolor="#2ca02c",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Philosopher D / School D",
        markersize=10,
        markerfacecolor="#d62728",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Philosopher E / School E",
        markersize=10,
        markerfacecolor="#9467bd",
    ),
]

# Create the legend using the custom handles
fig.legend(
    handles=legend_elements,
    loc="lower center",
    ncol=3,
    borderaxespad=0.05,
    frameon=False,
    bbox_to_anchor=(0.5, -0.05),
)

# Adjust the layout to make room for the legend
plt.subplots_adjust(bottom=0.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_52.pdf", bbox_inches="tight")
