
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points
trading_days = [1, 50, 100, 150, 200, 250]
stock_price_change = [5, 7, 3, 12, 8, 15]
labels = [None, "Tech Surge", None, "Market Correction", "Earnings Report", "Year End Rally"]
dashed_lines = [(1, 5, 50, 7), (200, 8, 250, 15)]

title = "Stock Market Analysis Over Trading Days"
xlabel = "Days of Trading"
ylabel = "Stock Price Change [%]"
texts = ["+2%", "Initial Growth", "Earnings Impact", "Seasonal Trends"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(8, 5))
plt.scatter(trading_days, stock_price_change, color="darkgreen", s=100, marker='o')  # Adjusted marker shape and color

# Annotating the data points
for i, label in enumerate(labels):
    plt.annotate(
        label,
        (trading_days[i], stock_price_change[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Plotting the dashed lines with correct colors and annotations
plt.plot([1, 50], [5, 7], linestyle="--", color="blue", linewidth=1.5)
plt.annotate(texts[0], (25, 6), color="blue")
plt.plot([100, 150], [3, 12], linestyle="--", color="red", linewidth=1.5)
plt.annotate(texts[1], (125, 7.5), color="red")
plt.plot([200, 250], [8, 15], linestyle="--", color="orange", linewidth=1.5)
plt.annotate(
    texts[2],
    (225, 11.5),
    color="orange",
    textcoords="offset points",
    xytext=(0, 10),
    ha="center",
)

# Annotating the dashed lines correctly
plt.annotate(texts[3], (250, 12.5), color="orange")

# Setting the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjusting y-axis scale
plt.ylim(0, 20)
plt.yticks([0, 5, 10, 15, 20])
plt.xlim(0, 300)
plt.xticks([0, 50, 100, 150, 200, 250, 300])
plt.grid(True)

# removing the top, left, and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_53.pdf", bbox_inches="tight")
