

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points
fertilizer_applied = [20, 40, 60, 80, 100, 120]  # kg
crop_yield = [2.5, 3.5, 4.2, 4.8, 4.5, 4.0]  # tons/ha
labels = ["Beginner", None, "Intermediate", None, "Advanced", "Expert"]
dashed_lines = [(20, 2.5, 60, 4.2), (80, 4.8, 120, 4.0)]

title = "Impact of Fertilizer on Crop Yield"
xlabel = "Fertilizer Applied (kg)"
ylabel = "Crop Yield (tons/ha)"
texts = ["+1.7 tons", "Peak Yield", "Decrease after Peak", "-0.8 tons"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(8, 5))
plt.scatter(fertilizer_applied, crop_yield, color="blue", s=100, marker='o')  # Adjusted marker size and color

# Annotating the data points
for i, label in enumerate(labels):
    plt.annotate(
        label,
        (fertilizer_applied[i], crop_yield[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Plotting the dashed lines with correct colors and annotations
plt.plot([20, 60], [2.5, 4.2], linestyle="--", color="red")
plt.annotate(texts[0], (40, 3.3), color="red")
plt.plot([80, 120], [4.8, 4.0], linestyle="--", color="green")
plt.annotate(texts[1], (80, 4.3), color="green")
plt.plot([20, 80], [2.5, 4.8], linestyle="--", color="purple")
plt.annotate(texts[2], (50, 4.0), color="purple")

# Annotating the dashed lines correctly
plt.annotate(texts[3], (100, 4.3), color="green")

# Setting the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjusting y-axis scale
plt.ylim(2.0, 5.0)
plt.yticks([2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0])
plt.xlim(0, 140)
plt.xticks([20, 40, 60, 80, 100, 120])
plt.grid(True)

# removing the top, left, and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_55.pdf", bbox_inches="tight")

