
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
age_groups = ["10-19", "20-29", "30-39", "40-49", "50-59", "60-69"]
average_hours = [15, 12, 10, 8, 6, 4]
sizes = [300, 500, 450, 350, 300, 250]

# Plot and legend labels
scatter_label = "Bubble Size: Number of Individuals Surveyed"

# Axis limits
xlim_values = None  # Not explicitly set in the code
ylim_values = (0, 20)

# Axis labels
xlabel_value = "Age Groups"
ylabel_value = "Average Hours Spent on Social Media per Week"

# Axis ticks
xticks_values = age_groups  # Set by FixedLocator
yticks_values = [0, 5, 10, 15, 20]

# Axis ticks labels
xtickslabel_values = age_groups
ytickslabel_values = None  # Not explicitly set in the code

# Title
title_value = "Social Media Usage by Age Group"

# Horizontal and vertical lines
axhline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(10, 8))
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
scatter = ax.scatter(
    age_groups,
    average_hours,
    s=sizes,
    c=colors,
    alpha=0.6,
    edgecolors="w",
    label=scatter_label,
    linewidth=2,
)

# Add labels for each bubble
for i, txt in enumerate(age_groups):
    ax.annotate(
        txt,
        (age_groups[i], average_hours[i]),
        ha="center",
        va="center",
        fontsize=10,
    )

# Set axis labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_ylim(ylim_values)
ax.set_xticks(range(len(age_groups)))
ax.set_xticklabels(xtickslabel_values)

# Add grid
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Set background color to white
fig.patch.set_facecolor("white")
ax.set_facecolor("white")

# Add a title
plt.title(title_value, fontsize=14, fontweight="bold")

# Add legend
legend = ax.legend()

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_57.pdf", bbox_inches="tight")
