
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
names = [
    "Community A",
    "Community B",
    "Community C",
    "Community D",
    "Community E",
    "Community F",
    "Community G",
    "Community H",
    "Community I",
]
x = [55, 65, 70, 60, 75, 80, 85, 90, 95]
y = [70, 75, 80, 85, 90, 88, 92, 94, 96]
sizes = [400, 600, 800, 500, 1000, 700, 900, 1100, 1200]
xlabel = "Community Engagement"
ylabel = "Happiness Index"
legend_sizes = [400, 600, 800, 1000, 1200]
legend_labels = ["400K", "600K", "800K", "1M", "1.2M"]
legend_title = "Resource Allocation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 7))
colors = [
    "#377eb8",
    "#377eb8",
    "#4daf4a",
    "#4daf4a",
    "#f781bf",
    "#f781bf",
    "#a65628",
    "#a65628",
    "#984ea3",
]
scatter = ax.scatter(x, y, s=sizes, c=colors, alpha=0.6, edgecolors="w", linewidth=0.5)

# Add annotations
for i, name in enumerate(names):
    ax.annotate(
        name,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=9,
    )

# Customize the axes
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xlim(50, 100)
ax.set_ylim(65, 100)

# Add legend for bubble sizes
for size, label in zip(legend_sizes, legend_labels):
    ax.scatter([], [], c="grey", alpha=0.5, s=size, label=label)

# Adjust the legend to have increased spacing
legend = ax.legend(
    scatterpoints=1,
    frameon=False,
    labelspacing=2,
    handletextpad=1,
    columnspacing=5,
    title=legend_title,
    fontsize=10,
    loc="upper center",
    bbox_to_anchor=(0.5, 1.2),
    ncol=len(legend_sizes),
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_60.pdf", bbox_inches="tight")
