
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "Party A",
    "Party B",
    "Party C",
    "Party D",
    "Party E",
    "Party F",
    "Party G",
    "Party H",
]
approval_ratings = [0.55, 0.70, 0.60, 0.75, 0.80, 0.65, 0.50, 0.45]
voter_turnout = [0.60, 0.65, 0.55, 0.70, 0.75, 0.60, 0.50, 0.40]
xlabel = "Political Parties"
ylabel = "Percentage Metrics"
labels = ["Approval Rating", "Voter Turnout"]
title = "Approval Ratings and Voter Turnout for Various Political Parties (2023)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(8, 4))

# Plotting data with different colors and marker styles
plt.scatter(categories, approval_ratings, color="#1f77b4", marker="o", s=100, label=labels[0])
plt.scatter(categories, voter_turnout, color="#ff7f0e", marker="s", s=100, label=labels[1])

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding grid with custom style
plt.grid(True, linestyle="--", linewidth=0.5)

# Rotate x-axis labels for better readability
plt.xticks(rotation=45)
plt.ylim(0, 1)

# Adjusting legend placement
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("scatter_66.pdf", bbox_inches="tight")
