
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plots
vehicle_types = [
    "Cars",
    "Buses",
    "Bikes",
    "Trucks",
    "Vans",
    "SUVs",
    "Motorcycles",
]
fuel_efficiency = [25, 10, 60, 15, 20, 18, 55]
maintenance_cost = [1500, 3000, 500, 4000, 2000, 2500, 600]

fuel_efficiency_2 = [25, 12, 58, 18, 22, 20, 53]
maintenance_cost_2 = [1600, 3200, 550, 4200, 2100, 2600, 650]

titles = [
    "Vehicle Types (Fuel Efficiency vs Maintenance Cost)",
    "Vehicle Types (Fuel Efficiency vs Maintenance Cost in Updated Data)",
]
xlabels = ["Fuel Efficiency (MPG)", "Fuel Efficiency (MPG)"]
ylabels = ["Maintenance Cost ($)", "Maintenance Cost ($)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Define colors (pastel shades)
colors1 = ["#FFB6C1", "#ADD8E6", "#98FB98", "#FFD700", "#87CEFA", "#FF69B4", "#FFA07A"]
colors2 = ["#FFB6C1", "#ADD8E6", "#98FB98", "#FFD700", "#87CEFA", "#FF69B4", "#FFA07A"]

# First subplot
ax1.scatter(fuel_efficiency, maintenance_cost, c=colors1, marker="o", edgecolor="black", s=100)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.invert_xaxis()  # Invert x-axis
for i, txt in enumerate(vehicle_types):
    ax1.annotate(
        txt, (fuel_efficiency[i], maintenance_cost[i]), xytext=(-10, 5), textcoords="offset points", fontsize=10
    )
ax1.set_xlim([65, 0])
ax1.set_ylim([0, 5000])

# Second subplot
ax2.scatter(fuel_efficiency_2, maintenance_cost_2, c=colors2, marker="s", edgecolor="black", s=100)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.ticklabel_format(style="sci", axis="y", scilimits=(0, 0))  # Use scientific notation
for i, txt in enumerate(vehicle_types):
    ax2.annotate(
        txt, (fuel_efficiency_2[i], maintenance_cost_2[i]), xytext=(-15, 5), textcoords="offset points", fontsize=10
    )
ax2.set_xlim([65, 0])
ax2.set_ylim([0, 5000])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_69.pdf", bbox_inches="tight")
