

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plots
sports_types = ["Football", "Basketball", "Baseball", "Soccer", "Tennis", "Cricket", "Hockey"]
average_attendance = [50, 20, 30, 40, 10, 15, 25]  # in thousands
player_ratings = [90, 85, 80, 88, 75, 70, 78]  # out of 100

operational_cost = [8e6, 4e6, 6e6, 7e6, 2.5e6, 3e6, 5e6]  # in dollars
annual_revenue = [12e6, 9e6, 10e6, 11e6, 4e6, 5e6, 7e6]  # in dollars

titles = [
    "Sports Types (Player Ratings vs Average Attendance)",
    "Sports Types (Player Ratings vs Operational Cost)",
]
xlabels = ["Average Attendance (thousands)", "Operational Cost (millions $)"]
ylabels = ["Average Player Ratings (out of 100)", "Average Player Ratings (out of 100)"]
legendlabels = ["Types of Sports"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 6))

colors = ["#4e79a7", "#f28e2c", "#e15759", "#76b7b2", "#59a14f", "#edc949", "#af7aa1"]
markers = ["o", "s", "D", "^", "v", "<", ">"]

# First subplot
for i, txt in enumerate(sports_types):
    ax1.scatter(average_attendance[i], player_ratings[i], color=colors[i], marker=markers[i], s=100, label=txt)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.set_xlim([0, 60])
ax1.set_ylim([60, 100])
ax1.grid(True)
ax1.legend(loc='best')

# Second subplot
for i, txt in enumerate(sports_types):
    ax2.scatter(operational_cost[i], player_ratings[i], color=colors[i], marker=markers[i], s=100, label=txt)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.ticklabel_format(style="sci", axis="x", scilimits=(0, 0))  # Use scientific notation
ax2.set_xlim([0, 9e6])
ax2.set_ylim([60, 100])
ax2.grid(True)
ax2.legend(loc='best')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_70.pdf", bbox_inches="tight")

