
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting - weather analysis
humidity = [
    45,
    70,
    50,
    90,
    60,
    40,
    80,
    55,
]  # Humidity in percentage
temperature = [
    30,
    35,
    28,
    40,
    33,
    25,
    38,
    29,
]  # Temperature in degree Celsius
cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
    "San Antonio",
    "San Diego",
]
xlabel = "Humidity (%)"
ylabel = "Temperature (°C)"
legend_title = "City"
suptitle = "Humidity vs. Temperature by City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 4))

# Custom color palette
colors = [
    "#1f77b4",  # New York - Blue
    "#ff7f0e",  # Los Angeles - Orange
    "#2ca02c",  # Chicago - Green
    "#d62728",  # Houston - Red
    "#9467bd",  # Phoenix - Purple
    "#8c564b",  # Philadelphia - Brown
    "#e377c2",  # San Antonio - Pink
    "#7f7f7f",  # San Diego - Grey
]
markers = [
    "o",
    "s",
    "D",
    "^",
    "v",
    "<",
    ">",
    "p",
]  # Different markers for different cities

# Plot each point with corresponding color and marker
for i, (hum, temp, color, marker) in enumerate(
    zip(humidity, temperature, colors, markers)
):
    ax.scatter(
        hum, temp, color=color, marker=marker, label=cities[i], edgecolor="black"
    )

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Create legend
legend = ax.legend(title=legend_title, bbox_to_anchor=(1.05, 1), loc="upper left")

# Additional style settings
ax.grid(True, linestyle="--", linewidth=0.5)
fig.suptitle(suptitle, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()
plt.savefig("scatter_72.pdf", bbox_inches="tight")
