
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
campaign_spending = [1.2, 3.0, 4.5, 2.5, 5.0, 3.2, 6.8, 4.0]  # Campaign spending in millions of dollars
voter_turnout = [50, 55, 60, 52, 70, 65, 80, 75]  # Voter turnout in percentage
candidates = ["Candidate A", "Candidate B", "Candidate C", "Candidate D", "Candidate E", "Candidate F", "Candidate G", "Candidate H"]

xlabel = "Campaign Spending (millions of dollars)"
ylabel = "Voter Turnout (%)"
legend_title = "Candidates"
title = "Campaign Spending vs. Voter Turnout"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

colors = [
    "green",
    "tan",
    "gold",
    "saddlebrown",
    "darkgreen",
    "peru",
    "lightgreen",
    "orange",
]  # Colors representing different candidates
markers = [
    "o",
    "v",
    "s",
    "^",
    "p",
    "*",
    "D",
    "X",
]  # Distinct markers for different candidates

# Plot each point with corresponding color and marker
for i, (spending, turnout, color, marker) in enumerate(
    zip(campaign_spending, voter_turnout, colors, markers)
):
    ax.scatter(spending, turnout, color=color, marker=marker, label=candidates[i])

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# Create legend
legend = ax.legend(title=legend_title, bbox_to_anchor=(1.05, 1), loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()
plt.savefig("scatter_73.pdf", bbox_inches="tight")
