
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new data for the entertainment domain
np.random.seed(1)
# Simulating Movie Ratings and Box Office Revenue data
movie_ratings = np.random.normal(75, 10, 100)  # Mean rating 75%, std 10%
box_office_revenue = np.random.normal(100, 30, 100)  # Mean revenue $100M, std $30M
xlabel = "Movie Ratings (%)"
ylabel = "Box Office Revenue (in Million $)"
title = "Scatter Plot of Movie Ratings vs Box Office Revenue"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
plt.figure(figsize=(9, 6))

# Scatter plot for the entertainment data
colors = np.random.rand(100)  # Random colors
sizes = 1000 * np.random.rand(100)  # Random sizes for the markers
plt.scatter(
    movie_ratings,
    box_office_revenue,
    c=colors,
    s=sizes,
    alpha=0.6,
    cmap="plasma",
    edgecolor="w",
)

# Enhance visibility of the grid
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.6)

# Set labels and title for the plot
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_75.pdf", bbox_inches="tight")
