
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Simulating data for the literature domain
reading_ease = np.random.normal(60, 15, 100)
critical_acclaim = np.random.normal(70, 10, 100)
xlabel = "Reading Ease"
ylabel = "Critical Acclaim"
title = "Reading Ease vs Critical Acclaim in Literature"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
plt.figure(figsize=(9, 6))

cmap = "plasma"

# Scatter plot for the literature dataset
colors = np.random.rand(100)
sizes = 1000 * np.random.rand(100)
plt.scatter(
    reading_ease,
    critical_acclaim,
    c=colors,
    s=sizes,
    alpha=0.6,
    cmap=cmap,
    marker="*",
)
plt.grid(True, linestyle="--", linewidth=0.5)

# Set labels and title for the plot
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_76.pdf", bbox_inches="tight")
