
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Group 1: Years Active vs. Number of Awards
years_active_group1 = np.random.randint(1, 40, size=13)
awards_group1 = np.random.randint(1, 15, size=13)

# Group 2: Years Active vs. Number of Awards
years_active_group2 = np.random.randint(1, 40, size=15)
awards_group2 = np.random.randint(1, 15, size=15)

legend_labels = ["Group 1", "Group 2"]
xlabel = "Years Active in Media"
ylabel = "Number of Awards"
title = "Media Professionals: Years Active vs. Number of Awards"
filename = "scatter_77_0.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 8))
plt.scatter(years_active_group1, awards_group1, color='blue', marker='o', s=100, alpha=0.6, edgecolors='w', label=legend_labels[0])
plt.scatter(years_active_group2, awards_group2, color='green', marker='s', s=100, alpha=0.6, edgecolors='w', label=legend_labels[1])
plt.grid(True)
plt.legend(legend_labels, fontsize=12)

# Adding axis labels and title
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_77.pdf", bbox_inches="tight")
