
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# City A: Number of Cases and Average Case Duration
num_cases_city_a = np.array(
    [50, 70, 80, 90, 60, 110, 65, 95, 75, 105, 115, 100, 85]
)
duration_city_a = np.array([12, 15, 14, 16, 14, 18, 13, 17, 15, 13, 19, 16, 14])

# City B: Number of Cases and Average Case Duration
num_cases_city_b = np.array(
    [65, 90, 100, 85, 95, 110, 80, 100, 105, 90, 120, 115, 110]
)
duration_city_b = np.array([11, 14, 13, 12, 15, 17, 12, 16, 14, 13, 12, 18, 14])

xlabel = "Number of Cases"
ylabel = "Average Case Duration (months)"
title = "Number of Cases vs. Average Case Duration in Two Cities"
legend_labels = ["City A", "City B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.scatter(
    num_cases_city_a, duration_city_a, color="skyblue", marker="o", edgecolor="black", s=100
)
plt.scatter(
    num_cases_city_b, duration_city_b, color="salmon", marker="^", edgecolor="black", s=100
)
plt.grid(True, linestyle="--", alpha=0.7)

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(legend_labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_79.pdf", bbox_inches="tight")
