
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the scatter plot
income = np.random.randint(20, 150, size=20)  # In thousands of dollars
education_level = np.random.uniform(8, 20, size=20)  # In years
population_density = np.random.randint(50, 5000, size=20)  # People per square mile
xlabel = "Average Income (in Thousands of Dollars)"
ylabel = "Education Level (Years)"
title = "Income vs Education Level"
colorbar_label = "Population Density (People per Sq Mile)"
suptitle = "Societal Trends Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.scatter(
    income, education_level, c=population_density, cmap="plasma", s=100, edgecolor="k", alpha=0.75
)
plt.grid(True, linestyle="--", linewidth=0.5)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
cbar = plt.colorbar()
cbar.set_label(colorbar_label)
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("scatter_82.pdf", bbox_inches="tight")
