
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Generating the communication data
number_of_messages = np.random.randint(100, 10000, size=(20))
response_time = np.random.uniform(0.5, 60, size=(20))
user_activity = np.random.uniform(1, 100, size=(20))
region_colors = np.random.randint(1, 10, size=(20))

# Text labels
title = "User Activity and Response Time"
xlabel = "Number of Messages"
ylabel = "Response Time (seconds)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(10, 8))

plt.scatter(number_of_messages, response_time, c=region_colors, s=user_activity * 10, 
            alpha=0.6, cmap="viridis", edgecolors='w', linewidth=0.5)

plt.colorbar(label="Region")
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_84.pdf", bbox_inches="tight")
