
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
regions = np.array([1, 2, 3, 4, 5, 6, 7])  # Representing different regions
average_speed = np.clip(
    50 + 10 * np.sin(np.linspace(0, 2 * np.pi, len(regions)))
    + np.random.normal(0, 5, len(regions)),
    40,
    60,
)
traffic_incidents = np.clip(
    5 + 2 * np.cos(np.linspace(0, 2 * np.pi, len(regions)))
    + np.random.normal(0, 1, len(regions)),
    3,
    8,
)
public_transport_usage = np.clip(
    25 + 5 * np.sin(np.linspace(0, 1 * np.pi, len(regions)))
    + np.random.normal(0, 2, len(regions)),
    20,
    30,
)
road_conditions = np.clip(
    7 + 1 * np.cos(np.linspace(0, 1.5 * np.pi, len(regions)))
    + np.random.normal(0, 0.5, len(regions)),
    6,
    8,
)
titles = ["Average Speed vs Public Transport Usage", "Traffic Incidents vs Road Conditions"]
figure1_scatter_labels = ["Average Speed (km/h)", "Public Transport Usage (%)"]
figure2_scatter_labels = ["Traffic Incidents", "Road Conditions Index"]
xlabel = "Regions"
ylabel = "Measurements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Color variables for consistency
color1 = "#1f77b4"  # blue
color2 = "#ff7f0e"  # orange
color3 = "#2ca02c"  # green
color4 = "#d62728"  # red

# The first subplot plots Average Speed and Public Transport Usage
ax1.scatter(
    regions,
    average_speed,
    color=color1,
    label=figure1_scatter_labels[0],
    marker="o",
    s=80,
    edgecolor="black",
)
ax1.scatter(
    regions,
    public_transport_usage,
    color=color2,
    label=figure1_scatter_labels[1],
    marker="s",
    s=80,
    edgecolor="black",
)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(loc="lower left")

# The second subplot plots Traffic Incidents and Road Conditions Index
ax2.scatter(
    regions,
    traffic_incidents,
    color=color3,
    label=figure2_scatter_labels[0],
    marker="^",
    s=80,
    edgecolor="black",
)
ax2.scatter(
    regions,
    road_conditions,
    color=color4,
    label=figure2_scatter_labels[1],
    marker="d",
    s=80,
    edgecolor="black",
)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.set_ylabel(ylabel, fontsize=12)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("scatter_86.pdf", bbox_inches="tight")
