
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(0)
months = np.arange(1, 13)
math_scores = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(months))) * 20 + np.random.normal(0, 3, len(months)) + 70,
    50,
    90,
)
study_hours = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(months))) * 10 + np.random.normal(0, 1.5, len(months)) + 30,
    15,
    45,
)
science_scores = np.clip(
    np.sin(np.linspace(0, 1 * np.pi, len(months))) * 20 + np.random.normal(0, 3, len(months)) + 70,
    50,
    90,
)
attendance_rate = np.clip(
    np.cos(np.linspace(0, 1.5 * np.pi, len(months))) * 10 + np.random.normal(0, 1.5, len(months)) + 85,
    70,
    95,
)
titles = ["Math Scores vs Study Hours", "Science Scores vs Attendance Rate"]
figure1_scatter_labels = ["Math Scores", "Study Hours"]
figure2_scatter_labels = ["Science Scores", "Attendance Rate"]
xlabel = "Months"
ylabel = "Scores/Hours"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# The first subplot plots Math Scores and Study Hours
ax1.scatter(
    months,
    math_scores,
    color="green",
    label=figure1_scatter_labels[0],
    marker="o",
    s=80,
    edgecolor="black",
)
ax1.scatter(
    months,
    study_hours,
    color="darkgreen",
    label=figure1_scatter_labels[1],
    marker="s",
    s=80,
    edgecolor="black",
)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(loc="upper right")
ax1.grid(True, linestyle='--', alpha=0.6)

# The second subplot plots Science Scores and Attendance Rate
ax2.scatter(
    months,
    science_scores,
    color="blue",
    label=figure2_scatter_labels[0],
    marker="^",
    s=80,
    edgecolor="black",
)
ax2.scatter(
    months,
    attendance_rate,
    color="darkblue",
    label=figure2_scatter_labels[1],
    marker="d",
    s=80,
    edgecolor="black",
)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.set_ylabel(ylabel, fontsize=12)
ax2.legend(loc="upper right")
ax2.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("scatter_87.pdf", bbox_inches="tight")
