
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
sectors = [
    "Technology",
    "Healthcare",
    "Finance",
    "Energy",
    "Consumer Goods",
    "Real Estate",
    "Utilities",
    "Telecommunications",
    "Industrials",
]
values = {
    "Market Growth": [8.5, 7.2, 6.8, 4.5, 5.8, 6.0, 4.2, 5.7, 6.5],
    "Profitability": [9.0, 8.0, 7.8, 5.0, 6.7, 7.5, 5.5, 6.0, 7.2],
    "Employee Satisfaction": [8.0, 8.5, 7.0, 6.2, 7.5, 7.8, 6.0, 7.0, 7.5],
    "Innovation": [9.5, 7.0, 6.5, 5.5, 6.8, 6.2, 5.0, 6.3, 7.0],
    "Customer Satisfaction": [8.7, 8.2, 7.5, 6.0, 7.2, 7.4, 6.5, 7.1, 7.3],
    "Environmental Impact": [7.0, 6.5, 6.8, 5.0, 6.2, 6.4, 5.5, 6.0, 6.7],
}
categorys1 = ["Market Growth", "Profitability"]
categorys2 = ["Employee Satisfaction", "Innovation"]
titles = ["Business Sectors Comparison", "Operational Metrics"]
xlabel = "Score"
ylabel = "Business Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 7), sharey=True)
colors1 = ["#1f77b4", "#ff7f0e"]  # Muted Blue and Orange
colors2 = ["#2ca02c", "#d62728"]  # Muted Green and Red
markers1 = ["o", "s"]  # Circle and Square
markers2 = ["^", "D"]  # Triangle Up and Diamond

# Plotting for ax1 - first two categories
for category, color, marker in zip(categorys1, colors1, markers1):
    ax1.scatter(
        values[category], sectors, color=color, label=category, marker=marker, s=100
    )
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(fontsize=10)

# Plotting for ax2 - next two categories
for category, color, marker in zip(categorys2, colors2, markers2):
    ax2.scatter(
        values[category], sectors, color=color, label=category, marker=marker, s=100
    )
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.legend(fontsize=10)

# Common settings
for ax in [ax1, ax2]:
    ax.set_yticks(range(len(sectors)))
    ax.set_yticklabels(sectors, fontsize=10)
    ax.grid(True, linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("scatter_90.pdf", bbox_inches="tight")
