

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate weather data (e.g., average temperature) for three different cities
years = np.linspace(2010, 2018, 9)
# Assume some realistic temperatures with some seasonality and noise
city1 = np.cumsum(np.random.normal(loc=1, scale=2, size=9)) + 15
city2 = np.cumsum(np.random.normal(loc=1, scale=2, size=9)) + 10
city3 = np.cumsum(np.random.normal(loc=1, scale=2, size=9)) + 5

sizes = np.linspace(50, 150, 9)  # Define marker sizes

titles = [
    "Average Temperature - City A",
    "Average Temperature - City B",
    "Average Temperature - City C",
]
xlabel = "Year"
ylabel = "Average Temperature (°C)"
cbar_label = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes objects
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Define color gradients for visual appeal
colors = ["forestgreen", "mediumseagreen", "lightgreen"]

# Plot scatter plots
for ax, city, color in zip(axs, [city1, city2, city3], colors):
    sc = ax.scatter(
        years,
        city,
        s=sizes,
        c=years,
        cmap="viridis",
        alpha=0.6,
        edgecolor="black",
    )
    ax.plot(
        years, city, color=color, linestyle="-", linewidth=1.5, alpha=0.8
    )  # Connect points with solid lines
    ax.set_title(f"Average Temperature - {color}")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_ylim(min(city) - 5, max(city) + 5)

# Add color bars to each subplot for color mapping explanation
for ax in axs:
    cb = plt.colorbar(sc, ax=ax, orientation="vertical")
    cb.set_label(cbar_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlapping
plt.tight_layout()

# Display the plot
plt.savefig("scatter_95.pdf", bbox_inches="tight")

