
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate data for approval ratings of three candidates over 12 months
x = np.linspace(1, 12, 12)  # Months
y1 = np.random.uniform(40, 60, 12) + np.random.normal(0, 2, 12)  # Candidate A
y2 = np.random.uniform(35, 55, 12) + np.random.normal(0, 2, 12)  # Candidate B
y3 = np.random.uniform(30, 50, 12) + np.random.normal(0, 2, 12)  # Candidate C

sizes = np.linspace(100, 200, 12)  # Define marker sizes

# Chart text labels
titles = [
    "Candidate A - Approval Ratings",
    "Candidate B - Approval Ratings",
    "Candidate C - Approval Ratings",
]
xlabel = "Months"
ylabel = "Approval Ratings (%)"
cbar_label = "Months"
suptitle = "Approval Ratings of Political Candidates Over 12 Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes objects
fig, axs = plt.subplots(1, 3, figsize=(18, 6))

# Define color schemes relevant to tech
colors = ["steelblue", "seagreen", "rebeccapurple"]
markers = ["o", "s", "d"]

# Plot scatter plots
for ax, y, color, marker, title in zip(axs, [y1, y2, y3], colors, markers, titles):
    sc = ax.scatter(
        x,
        y,
        s=sizes,
        c=x,
        cmap="cool",
        alpha=0.6,
        edgecolor="black",
        marker=marker,
    )
    ax.plot(
        x, y, color=color, linestyle="-", alpha=0.7, linewidth=2
    )  # Connect points with solid lines
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_ylim(min(y) - 5, max(y) + 5)

# Add color bars to each subplot for color mapping explanation
for ax in axs:
    cb = plt.colorbar(sc, ax=ax, orientation="vertical")
    cb.set_label(cbar_label)

# Set a super title for the entire figure
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlapping
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

# Display the plot
plt.savefig("scatter_96.pdf", bbox_inches="tight")
