
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate data
x = np.linspace(1, 12, 12)  # Representing months

# Simulate financial data
y1 = 100 + x * np.random.uniform(10, 15, 12) + np.random.normal(0, 20, 12)  # Stock Prices
y2 = np.random.uniform(5000, 10000, 12) + np.random.normal(0, 500, 12)      # Trading Volume
y3 = 1000 + x * np.random.uniform(50, 70, 12) + np.random.normal(0, 100, 12)  # Market Index

sizes = np.linspace(100, 200, 12)  # Define marker sizes

titles = [
    "Monthly Stock Prices",
    "Monthly Trading Volume",
    "Monthly Market Index",
]
xlabel = "Months"
ylabel = "Financial Metric"
cbar_label = "Month Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes objects
fig, axs = plt.subplots(1, 3, figsize=(18, 6))

# Define new color gradients for visual appeal
colors = ["#FF5733", "#33C1FF", "#33FF57"]  # Custom color palette

# Plot scatter plots
for ax, y, color, title in zip(axs, [y1, y2, y3], colors, titles):
    sc = ax.scatter(
        x,
        y,
        s=sizes,
        c=x,
        cmap="plasma",  # New color map
        alpha=0.7,
        edgecolor="grey",
    )
    ax.plot(
        x, y, color=color, linestyle="-.", linewidth=1.5, alpha=0.7
    )  # Connect points with dash-dot lines
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.set_ylim(min(y) - 10, max(y) + 10)

# Add color bars to each subplot for color mapping explanation
for ax in axs:
    cb = plt.colorbar(sc, ax=ax, orientation="vertical")
    cb.set_label(cbar_label, fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlapping
plt.tight_layout()

# Display the plot
plt.savefig("scatter_97.pdf", bbox_inches="tight")
