
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Data: Distribution of Weather Conditions in a Typical Year (%)
sizes = [30.0, 25.0, 15.0, 8.0, 12.0, 5.0, 3.0, 2.0]
labels = [
    "Sunny\n30%",
    "Cloudy\n25%",
    "Rainy\n15%",
    "Stormy\n8%",
    "Snowy\n12%",
    "Foggy\n5%",
    "Windy\n3%",
    "Hail\n2%",
]

# Text labels and colors
title = "Distribution of Weather Conditions in a Typical Year (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

colors = [
    "#1b9e77",
    "#d95f02",
    "#7570b3",
    "#e7298a",
    "#66a61e",
    "#e6ab02",
    "#a6761d",
    "#666666",
]

# Create a treemap with custom colors and transparency
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 14, "weight": "bold"},
)

# Remove axes
plt.axis("off")

# Title Configuration
plt.title(title, fontsize=20, weight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_21.pdf", bbox_inches="tight")
