
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data: Market capitalization (in billions) for various major companies
market_caps = [2200, 1800, 1600, 1400, 1200, 1000, 900, 750]
company_labels = [
    "Apple\n2200 B",
    "Microsoft\n1800 B",
    "Amazon\n1600 B",
    "Google\n1400 B",
    "Facebook\n1200 B",
    "Alibaba\n1000 B",
    "Tencent\n900 B",
    "Tesla\n750 B",
]

title = "Market Capitalization of Major Companies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Color scheme for market capitalization
market_cap_colors = [
    "#c7e9b4",
    "#7fcdbb",
    "#41b6c4",
    "#1d91c0",
    "#225ea8",
    "#253494",
    "#081d58",
    "#4d004b",
]

# Create a treemap
squarify.plot(
    sizes=market_caps,
    label=company_labels,
    color=market_cap_colors,
    alpha=0.8,
    text_kwargs={"fontsize": 15, "weight": "bold"},
)

# Remove axes
plt.axis("off")

# Add a title to the plot
plt.title(title, fontsize=20)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_22.pdf", bbox_inches="tight")
